#include "commonheaders.h"
#include "cls-window.h"
#include "window.h"
#include "processing.h"

short tempX2 = -1;
short tempY2 = -1;

void MapPlace(short xLocation, short yLocation) {
    if(yLocation >= 0 && xLocation >= 0){
        if(yLocation < MapYSize && xLocation < MapXSize){
            if(roomamount > 0 && roomtype < 7) {
                MapGrid[yLocation][xLocation] = selectedroom + 1;
                MapSpec[yLocation][xLocation] = roomtype;
                //printf("%i,%i\n", yLocation,xLocation);
            } else if(roomamount > 0 && (roomtype == 7 || roomtype == 9) && stchhold == false) {
                if(stchpress == false) {
                    stchpress = true;
                    stchhold = true;
                    stchxPos = xLocation;
                    stchyPos = yLocation;
                    stchxEnd = xLocation;
                    stchyEnd = yLocation;
                } else {
                    stchhold = true;
                    stchpress = false;
                    if(roomtype == 7) {
                        short yinc;
                        if((stchyEnd - stchyPos) != 0)
                            yinc = (stchyEnd - stchyPos)/abs(stchyEnd - stchyPos);
                        else
                            yinc = 1;
                        short xinc;
                        if((stchxEnd - stchxPos) != 0)
                            xinc = (stchxEnd - stchxPos)/abs(stchxEnd - stchxPos);
                        else
                            xinc = 1;
                        for(short y = stchyPos; y != stchyEnd + yinc; y += yinc) {
                            for(short x = stchxPos; x != stchxEnd + xinc; x += xinc) {
                                MapGrid[y][x] = selectedroom + 1;
                                MapSpec[y][x] = 0;
                            }
                        }
                    } else {
                        MapGrid[stchyPos][stchxPos] = selectedroom + 1;
                        MapSpec[stchyPos][stchxPos] = 9 + stchNum;
                        MapGrid[stchyEnd][stchxEnd] = selectedroom + 1;
                        MapSpec[stchyEnd][stchxEnd] = 9 + stchNum;
                        stchNum ++;
                    }
                    stchxPos = 0;
                    stchyPos = 0;
                    stchxEnd = 0;
                    stchyEnd = 0;
                }
            }
        }
    }
}

void MapErase(short xLocation, short yLocation) {
    if(yLocation >= 0 && xLocation >= 0){
        if(yLocation < MapYSize && xLocation < MapXSize){
            MapGrid[yLocation][xLocation] = 0;
            MapSpec[yLocation][xLocation] = 0;
            if(stchpress) {
                stchpress = false;
                stchxPos = 0;
                stchyPos = 0;
                stchxEnd = 0;
                stchyEnd = 0;
            }
        }
    }
}

void MapHover(short xLocation, short yLocation) {
    if(!(mouse_b & 1) && stchhold) {
        stchhold = false;
    }
    if(stchpress && roomtype == 7) {
        stchxEnd = xLocation;
        stchyEnd = yLocation;
    } else if(stchpress) {
        stchpress = false;
        stchxPos = 0;
        stchyPos = 0;
        stchxEnd = 0;
        stchyEnd = 0;
    }
	tempX2 = xLocation;
	tempY2 = yLocation;
}

void MapDraw(BITMAP *output, short gridSize) {
    if(tempX2 > -1 && tempY2 > -1) {
    short y = Windows[RWin("Map Editor")]->Viewports[0]->yScroll;
    short x = Windows[RWin("Map Editor")]->Viewports[0]->xScroll;
    BITMAP *ex = NULL;
    BITMAP *temp = create_bitmap(8, 8);
    clear_to_color(temp, makecol(255, 0, 255));
    if(tempY2 >= 0 && tempX2 >= 0){
        if(tempY2 < MapYSize && tempX2 < MapXSize){
            if(selectedroom + 1 > 0 && roomtype < 2 || (roomtype == 7 && !stchpress)) {
                ex = create_bitmap(gridSize, gridSize);
                clear_to_color(temp, makecol(216, 56, 144));
                if(tempY2 > 0) {
                    if(MapGrid[tempY2 - 1][tempX2] != selectedroom + 1 || 
                    (MapSpec[tempY2 - 1][tempX2] >= 4 && MapSpec[tempY2 - 1][tempX2] <= 6) || roomtype == 7)
                        line(temp, 0, 0, 7, 0, makecol(248, 248, 248));
                    if(MapSpec[tempY2 - 1][tempX2] == 6) {
                        line(temp, 2, 0, 5, 0, makecol(216, 56, 144));
                        line(temp, 3, 6, 4, 6, makecol(248, 0, 0));
                        _putpixel16(temp, 0, 1, makecol(248, 248, 248));
                        _putpixel16(temp, 7, 1, makecol(248, 248, 248));
                    }
                } else {
                    line(temp, 0, 0, 7, 0, makecol(248, 248, 248));
                }
                if(tempY2 < MapYSize - 1){
                    if(MapGrid[tempY2 + 1][tempX2] != selectedroom + 1 || 
                    MapSpec[tempY2 + 1][tempX2] == 2 || 
                    MapSpec[tempY2 + 1][tempX2] == 3 || 
                    MapSpec[tempY2 + 1][tempX2] == 6 || roomtype == 7) 
                        line(temp, 0, 7, 7, 7, makecol(248, 248, 248));
                    if(MapSpec[tempY2 + 1][tempX2] == 6) {
                        line(temp, 2, 7, 5, 7, makecol(216, 56, 144));
                        line(temp, 3, 6, 4, 6, makecol(248, 0, 0));
                        _putpixel16(temp, 0, 6, makecol(248, 248, 248));
                        _putpixel16(temp, 7, 6, makecol(248, 248, 248));
                    }
                } else {
                    line(temp, 0, 7, 7, 7, makecol(248, 248, 248));
                }
                
                if(tempX2 > 0){
                    if(MapGrid[tempY2][tempX2 - 1] != selectedroom + 1 || 
                    MapSpec[tempY2][tempX2 - 1] == 3 || 
                    MapSpec[tempY2][tempX2 - 1] == 4 || 
                    MapSpec[tempY2][tempX2 - 1] == 6 || roomtype == 7) 
                        line(temp, 0, 0, 0, 7, makecol(248, 248, 248));
                } else {
                    line(temp, 0, 0, 0, 7, makecol(248, 248, 248));
                }
                if(tempX2 < MapXSize - 1){
                    if(MapGrid[tempY2][tempX2 + 1] != selectedroom + 1 || 
                    MapSpec[tempY2][tempX2 + 1] == 2 || 
                    MapSpec[tempY2][tempX2 + 1] == 5 || 
                    MapSpec[tempY2][tempX2 + 1] == 6 || roomtype == 7) 
                        line(temp, 7, 0, 7, 7, makecol(248, 248, 248));
                } else {
                    line(temp, 7, 0, 7, 7, makecol(248, 248, 248));
                }
                
                if(roomtype == 1) {
                    rectfill(temp, 3, 3, 4, 4, makecol(248, 248, 248));
                }
                stretch_blit(temp, ex, 0, 0, 8, 8, 0, 0, gridSize, gridSize);
            } else if(roomtype > 1) {
                ex = create_bitmap(gridSize, gridSize);
                if(roomtype == 2) {
                    for(short y = 0; y < 8; y++) {
                        for(short x = y; x < 8; x++) {
                            _putpixel16(temp, x, 7 - y, makecol(216, 56, 144));
                        }
                    }
                    line(temp, 7, 0, 0, 7, makecol(248, 248, 248));
                } else if(roomtype == 3) {
                    for(short y = 0; y < 8; y++) {
                        for(short x = 0; x < y; x++) {
                            _putpixel16(temp, x, y, makecol(216, 56, 144));
                        }
                    }
                    line(temp, 0, 0, 7, 7, makecol(248, 248, 248));
                } else if(roomtype == 4) {
                    for(short y = 0; y < 8; y++) {
                        for(short x = 0; x < y; x++) {
                            _putpixel16(temp, x, 7 - y, makecol(216, 56, 144));
                        }
                    }
                    line(temp, 7, 0, 0, 7, makecol(248, 248, 248));
                } else if(roomtype == 5) {
                    for(short y = 0; y < 8; y++) {
                        for(short x = 7 - y; x < 8; x++) {
                            _putpixel16(temp, x, 7 - y, makecol(216, 56, 144));
                        }
                    }
                    line(temp, 0, 0, 7, 7, makecol(248, 248, 248));
                } else if(roomtype == 6) {
                    blit(MapElevator, temp, 0, 0, 0, 0, 8, 8);
                }
                stretch_blit(temp, ex, 0, 0, 8, 8, 0, 0, gridSize, gridSize);
            }
        }
    }
    destroy_bitmap(temp);
    /*return ex;
	BITMAP *temp = create_bitmap(gridSize, gridSize);
	rectfill(temp, 0, 0, temp->w, temp->h, makecol(216, 56, 144));
	rect(temp, 0, 0, temp->w - 1, temp->h - 1, makecol(248, 248, 248));
	rect(temp, 1, 1, temp->w - 2, temp->h - 2, makecol(248, 248, 248));*/
	if(ex != NULL) {
	   set_trans_blender(0,0,0,128);
	   draw_trans_sprite(output, ex, (tempX2 - x) * gridSize + 1, (tempY2 - y) * gridSize + 1);
    }
    
    if(stchpress) {
	    destroy_bitmap(ex);
	    ex = create_bitmap((abs(stchxPos - stchxEnd) + 1) * gridSize, (abs(stchyPos - stchyEnd) + 1) * gridSize);
	    rectfill(ex, 0, 0, ex->w, ex->h, makecol(216, 56, 144));
    	rect(ex, 0, 0, ex->w - 1, ex->h - 1, makecol(248, 248, 248));
	    rect(ex, 1, 1, ex->w - 2, ex->h - 2, makecol(248, 248, 248));
        set_trans_blender(0,0,0,128);
        short x2, y2;
        x2 = (stchxPos <= stchxEnd ? stchxPos : stchxEnd);
        y2 = (stchyPos <= stchyEnd ? stchyPos : stchyEnd);
	    draw_trans_sprite(output, ex, (x2 - x) * gridSize + 1, (y2 - y) * gridSize + 1);
    }
	destroy_bitmap(ex);
    }
}

BITMAP *MapViewport(short xLocation, short yLocation) {
    BITMAP *ex = NULL;
    BITMAP *temp = create_bitmap(8, 8);
    clear_to_color(temp, makecol(255, 0, 255));
    short selroom = (MapGrid[yLocation][xLocation] == selectedroom + 1 ? 56 : 0);
    if(yLocation >= 0 && xLocation >= 0){
        if(yLocation < MapYSize && xLocation < MapXSize){
            if(MapGrid[yLocation][xLocation] > 0 && MapSpec[yLocation][xLocation] < 2) {
                ex = create_bitmap(16, 16);
                clear_to_color(temp, makecol(216, 56 - selroom, 144 - selroom));
                if(yLocation > 0) {
                    if(MapGrid[yLocation - 1][xLocation] != MapGrid[yLocation][xLocation] || 
                    (MapSpec[yLocation - 1][xLocation] >= 4 && MapSpec[yLocation - 1][xLocation] <= 6))
                        line(temp, 0, 0, 7, 0, makecol(248, 248, 248));
                    if(MapSpec[yLocation - 1][xLocation] == 6) {
                        line(temp, 2, 0, 5, 0, makecol(216, 56, 144));
                        line(temp, 3, 6, 4, 6, makecol(248, 0, 0));
                        _putpixel16(temp, 0, 1, makecol(248, 248, 248));
                        _putpixel16(temp, 7, 1, makecol(248, 248, 248));
                    }
                } else {
                    line(temp, 0, 0, 7, 0, makecol(248, 248, 248));
                }
                if(yLocation < MapYSize - 1){
                    if(MapGrid[yLocation + 1][xLocation] != MapGrid[yLocation][xLocation] || 
                    MapSpec[yLocation + 1][xLocation] == 2 || 
                    MapSpec[yLocation + 1][xLocation] == 3 || 
                    MapSpec[yLocation + 1][xLocation] == 6) 
                        line(temp, 0, 7, 7, 7, makecol(248, 248, 248));
                    if(MapSpec[yLocation + 1][xLocation] == 6) {
                        line(temp, 2, 7, 5, 7, makecol(216, 56, 144));
                        line(temp, 3, 6, 4, 6, makecol(248, 0, 0));
                        _putpixel16(temp, 0, 6, makecol(248, 248, 248));
                        _putpixel16(temp, 7, 6, makecol(248, 248, 248));
                    }
                } else {
                    line(temp, 0, 7, 7, 7, makecol(248, 248, 248));
                }
                
                if(xLocation > 0){
                    if(MapGrid[yLocation][xLocation - 1] != MapGrid[yLocation][xLocation] || 
                    MapSpec[yLocation][xLocation - 1] == 3 || 
                    MapSpec[yLocation][xLocation - 1] == 4 || 
                    MapSpec[yLocation][xLocation - 1] == 6) 
                        line(temp, 0, 0, 0, 7, makecol(248, 248, 248));
                } else {
                    line(temp, 0, 0, 0, 7, makecol(248, 248, 248));
                }
                if(xLocation < MapXSize - 1){
                    if(MapGrid[yLocation][xLocation + 1] != MapGrid[yLocation][xLocation] || 
                    MapSpec[yLocation][xLocation + 1] == 2 || 
                    MapSpec[yLocation][xLocation + 1] == 5 || 
                    MapSpec[yLocation][xLocation + 1] == 6) 
                        line(temp, 7, 0, 7, 7, makecol(248, 248, 248));
                } else {
                    line(temp, 7, 0, 7, 7, makecol(248, 248, 248));
                }
                
                if(MapSpec[yLocation][xLocation] == 1) {
                    rectfill(temp, 3, 3, 4, 4, makecol(248, 248, 248));
                }
                stretch_blit(temp, ex, 0, 0, 8, 8, 0, 0, 16, 16);
            } else if(MapSpec[yLocation][xLocation] > 1) {
                ex = create_bitmap(16, 16);
                if(MapSpec[yLocation][xLocation] == 2) {
                    for(short y = 0; y < 8; y++) {
                        for(short x = y; x < 8; x++) {
                            _putpixel16(temp, x, 7 - y, makecol(216, 56 - selroom, 144 - selroom));
                        }
                    }
                    line(temp, 7, 0, 0, 7, makecol(248, 248, 248));
                } else if(MapSpec[yLocation][xLocation] == 3) {
                    for(short y = 0; y < 8; y++) {
                        for(short x = 0; x < y; x++) {
                            _putpixel16(temp, x, y, makecol(216 - selroom, 56 - selroom, 144 - selroom));
                        }
                    }
                    line(temp, 0, 0, 7, 7, makecol(248, 248, 248));
                } else if(MapSpec[yLocation][xLocation] == 4) {
                    for(short y = 0; y < 8; y++) {
                        for(short x = 0; x < y; x++) {
                            _putpixel16(temp, x, 7 - y, makecol(216 - selroom, 56 - selroom, 144 - selroom));
                        }
                    }
                    line(temp, 7, 0, 0, 7, makecol(248, 248, 248));
                } else if(MapSpec[yLocation][xLocation] == 5) {
                    for(short y = 0; y < 8; y++) {
                        for(short x = 7 - y; x < 8; x++) {
                            _putpixel16(temp, x, 7 - y, makecol(216 - selroom, 56 - selroom, 144 - selroom));
                        }
                    }
                    line(temp, 0, 0, 7, 7, makecol(248, 248, 248));
                } else if(MapSpec[yLocation][xLocation] == 6) {
                    blit(MapElevator, temp, 0, 0, 0, 0, 8, 8);
                }
                stretch_blit(temp, ex, 0, 0, 8, 8, 0, 0, 16, 16);
            }
        }
    }
    if(ex && MapGrid[yLocation][xLocation] == selectedroom + 1)
    {
        //BITMAP *overlay = create_bitmap(ex->w, ex->h);
        //clear_to_color(overlay, makecol(255, 0, 0));
        //set_trans_blender(0, 0, 0, 64);
        //draw_trans_sprite(ex, overlay, 0, 0);
        //destroy_bitmap(overlay);
    }
    destroy_bitmap(temp);
    return ex;
}

